define(['angular', 'angularMocks', 'EulaController', 'angularUiRouter'], function(angular, mocks) {
    'use strict';

    describe("The Eula controller", function (){
        var controller, 
            scope, 
            state, 
            eulaServiceMock,
            pageServiceMock;
        
        beforeEach( function () {
            module('angularTemplateApp');

            eulaServiceMock = jasmine.createSpyObj('eulaService', ['setAcceptedDate']);
            pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
            module(function($provide){
                $provide.value('eulaService', eulaServiceMock);
                $provide.value('pageService', pageServiceMock);
            });

            inject(function($controller, $rootScope, $state) {
                scope = $rootScope.$new();
                state = $state;
                controller = $controller('EulaController', {$scope:scope});
            });
        });

        describe("when accept button is clicked", function (){
            
            beforeEach( function () {
                spyOn(state, 'go');
                scope.acceptClicked();   
            });

            it ("should call setAcceptedDate on eulaService", function() {
                expect(eulaServiceMock.setAcceptedDate).toHaveBeenCalled();
            });
            it ("should change state to main", function() {
                expect(state.go).toHaveBeenCalledWith('main.auth.authenticated-user');
            });
        });

        describe("when decline button is clicked", function (){
            
            beforeEach( function () {
                scope.declineClicked();   
            });

            it ("should call the global function to redirect to launchpad", function() {
                expect(pageServiceMock.redirectToLaunchpad).toHaveBeenCalled();
            });
        });
    });
});